/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgConvolve.c                                                 */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:33 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Convolve"
#define ERROR(e) imgError(e,PRGNAME)
#define ARG_ERROR(e,arg) imgArgError(e,arg,PRGNAME)

int main(int argc,char **argv)
{
  it_image *in,*kernel,*out;
  int width,height;

  IFHELP
    {
      fprintf(stderr,"img%s - Convolve float images with a kernel\n",
	      PRGNAME);
      fprintf(stderr,"img%s filename\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: Float\n");
      fprintf(stderr,"  file: Double\n");
      exit(0);
    }
  imgStart(PRGNAME);

  if(argc!=2)
    ERROR("invalid arguments");

  /* Loop for all images */
  do {
    in=i_read_image_file(stdin,IT_FLOAT,IM_CONTIG);
    if(in==NULL)
      ERROR("can't import image file");
    width=in->width;
    height=in->height;

    out=i_create_image(width,height,IT_FLOAT,IM_CONTIG);
    if(out==NULL)
      ERROR("out of memory");

    kernel=i_load_image(argv[1],-1,IT_DOUBLE,IM_CONTIG);
    if(kernel==NULL)
      ARG_ERROR("can't load image file %s",argv[1]);

    i_convolve(in,out,kernel);

    i_destroy_image(in);
    i_write_image_file(stdout,out,IF_BINARY);
    i_destroy_image(out);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
