/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgFlip.c                                                     */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:40 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Flip"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *i1,*i2;
  int width,height,x,y;
  int flip_x=0,flip_y=0;

  IFHELP
    {
      fprintf(stderr,"img%s - Flip image vertically or horizontally\n",
	      PRGNAME);
      fprintf(stderr,"img%s [x][y]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: pgm\n");
      fprintf(stderr,"  stdout: pgm\n");
      fprintf(stderr,"  'x' - flip left-right, 'y' - flip top-bottom, 'xy' - both\n");
      exit(0);
    }
  imgStart(PRGNAME);

  if(argc>1)
    {
      if(argv[1][0]=='x'||(argv[1][0]!='\0'&&argv[1][1]=='x'))
	flip_x=1;
      if(argv[1][0]=='y'||(argv[1][0]!='\0'&&argv[1][1]=='y'))
	flip_y=1;
      if(argc>2)
	{
	  if(argv[2][0]=='x')
	    flip_x=1;
	  if(argv[2][0]=='y')
	    flip_y=1;
	}
    }
  if(flip_x+flip_y==0)
    flip_x=1;

  do {
    i1=i_read_image_file(stdin,IT_BYTE,IM_FRAGMENT);
    if(i1==NULL)
      ERROR("can't import image file (check type)");
    width=i1->width;
    height=i1->height;

    i2=i_create_image(width,height,IT_BYTE,IM_FRAGMENT);
    if(i2==NULL)
      ERROR("out of memory");

    if(flip_x)
      for(y=0;y<height;y++)
	for(x=0;x<width;x++)
	  im_byte_value(i2,width-x-1,y)=im_byte_value(i1,x,y);
    if(flip_y)
      {
	if(flip_x)
	  for(y=0;y<height;y++)
	    for(x=0;x<width;x++)
	      im_byte_value(i1,x,height-y-1)=im_byte_value(i2,x,y);
	else
	  for(y=0;y<height;y++)
	    for(x=0;x<width;x++)
	      im_byte_value(i2,x,height-y-1)=im_byte_value(i1,x,y);
      }
    if(flip_x && flip_y)
      i_write_image_file(stdout,i1,IF_BINARY);
    else
      i_write_image_file(stdout,i2,IF_BINARY);

    i_destroy_image(i1);
    i_destroy_image(i2);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
