/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgRankFilter.c                                               */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:54 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "RankFilter"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *f1,*f2;
  int x,y,width,height,rank,i,j,k;
  float v[9],vv,*ptr1,*ptr2,*ptr3,*ptr4;

  IFHELP
    {
      fprintf(stderr,"img%s - Perform rank-value filtering\n",
	      PRGNAME);
      fprintf(stderr,"img%s [rank]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: Float\n");
      fprintf(stderr,"  rank=1: erosion, rank=9: dilation, rank=5: median filtering\n");
      exit(0);
    }
  imgStart(PRGNAME);

  /* Get value of sigma from argument line (if any) */
  rank=5;
  if(argc!=1 && argc!=2)
    ERROR("invalid arguments");
  if(argc==2)
    rank=atoi(argv[1]);
  if(rank<1 || rank>9)
    ERROR("rank value must be in the range 1--9");

  /* Loop for all images */
  do {
    f1=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
    if(f1==NULL)
      ERROR("can't import image file");

    f2=i_create_image(f1->width,f1->height,IT_FLOAT,IM_FRAGMENT);
    if(f2==NULL)
      ERROR("out of memory");

    width=f1->width;
    height=f1->height;

    for(y=0;y<height-2;y++)
      {
	ptr1=im_float_row(f1,y);
	ptr2=im_float_row(f1,y+1);
	ptr3=im_float_row(f1,y+2);
	ptr4=im_float_row(f2,y+1)+1;
	for(x=0;x<width-2;x++)
	  {
	    v[0]= *ptr1++;
	    v[1]= *ptr1++;
	    v[2]= *ptr1--;
	    v[3]= *ptr2++;
	    v[4]= *ptr2++;
	    v[5]= *ptr2--;
	    v[6]= *ptr3++;
	    v[7]= *ptr3++;
	    v[8]= *ptr3--;

	    /* Sort into ascending order */
	    for(i=0;i<rank;i++)
	      {
		for(j=i+1,k=i;j<9;j++)
		  if(v[j]<v[k])
		    k=j;
		vv=v[i];
		v[i]=v[k];
		v[k]=vv;
	      }
	    *ptr4++ =v[rank-1];
	  }
      }
    f2->min_value=f1->min_value;
    f2->max_value=f1->max_value;
    f2->valid_x=f1->valid_x+1;
    f2->valid_y=f1->valid_y+1;
    f2->valid_width=f1->valid_width-2;
    f2->valid_height=f1->valid_height-2;

    i_write_image_file(stdout,f2,IF_BINARY);
    i_destroy_image(f1);
    i_destroy_image(f2);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
