#!/bin/sh

# $Id: types.sh,v 1.3 1994/02/22 07:45:22 gkim Exp $

# types.sh
#
# glean any missing struct stat typedefs.
#
# Gene Kim
# Purdue University
# October 18, 1992

# this used to be a -x test, but Apollos can't process it!
if test ! -f ./types
then
    echo "You must do 'make' first!"
    exit 1
fi

CPP=${1?"Run from the makefile!"}

TYPES=./ourtypes.h

# build our own local copy of types.h

cat > gettypes.c << 'GHK'
#include <sys/stat.h>
#include <sys/types.h>
GHK
$CPP gettypes.c > $TYPES
rm -f gettypes.c

# print out banner for inode.h

cat << 'GHK'
/*
 * inode.h
 *
 * 	Do not modify this file.  This file was automatically 
 * 	generated by the Tripwire makefile.
 *
 */

GHK

# now start finding the missing typedefs

grep mode_t $TYPES > /dev/null 
if [ $? -ne 0 ]
then
    ./types mode_t;
fi

grep ino_t $TYPES > /dev/null
if [ $? -ne 0 ]
then
    ./types ino_t; 
fi

grep nlink_t $TYPES > /dev/null
if [ $? -ne 0 ]
then
    ./types nlink_t;
fi

grep uid_t $TYPES > /dev/null
if [ $? -ne 0 ]
then
    ./types uid_t;
fi

grep gid_t $TYPES > /dev/null
if [ $? -ne 0 ]
then
    ./types gid_t;
fi

grep off_t $TYPES > /dev/null
if [ $? -ne 0 ]
then
    ./types off_t;
fi

rm $TYPES

exit 0;
